<?php

use Illuminate\Support\Facades\Route;
use Livewire\Volt\Volt;

Route::get('/', function () {
    return to_route('login');
})->name('home');

Route::view('dashboard', 'dashboard')
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::middleware(['auth'])->group(function () {
    Route::redirect('settings', 'settings/profile');

    Volt::route('settings/profile', 'settings.profile')->name('settings.profile');
    Volt::route('settings/password', 'settings.password')->name('settings.password');
    Volt::route('settings/appearance', 'settings.appearance')->name('settings.appearance');
});

Route::middleware(['auth', 'verified'])->group(function () {
    Volt::route('domains', 'domains.index')->name('domains.index');
    Volt::route('domains/create', 'domains.create')->name('domains.create');
    Volt::route('domains/{domain}', 'domains.show')->name('domains.show');
    Volt::route('domains/{domain}/edit', 'domains.edit')->name('domains.edit');
    Volt::route('domains/{domain}/delete', 'domains.delete')->name('domains.delete');
});
Route::middleware(['auth', 'verified'])->group(function () {
    Volt::route('nameServers', 'nameServers.index')->name('nameServers.index');
    Volt::route('nameServers/create', 'nameServers.create')->name('nameServers.create');
    Volt::route('nameServers/{nameServer}', 'nameServers.show')->name('nameServers.show');
    Volt::route('nameServers/{nameServer}/edit', 'nameServers.edit')->name('nameServers.edit');
    Volt::route('nameServers/{nameServer}/delete', 'nameServers.delete')->name('nameServers.delete');
});

require __DIR__.'/auth.php';
