<x-layouts.app :title="__('Dashboard')">
    @php
        // $user = \Illuminate\Support\Facades\Auth::user();
        $totalDomains = \App\Models\Domain::count();
        $totalNameServers = \App\Models\NameServer::count();
        // $recentDomains = \App\Models\Domain::where('user_id', $user->id)->latest()->take(5)->get();
        // $recentNameServers = \App\Models\NameServer::whereIn('domain_id', \App\Models\Domain::where('user_id', $user->id)->pluck('id'))->latest()->take(5)->get();
    @endphp

    @include('partials.settings-heading', [
    'heading' => __('Halo, :name', ['name' => auth()->user()->name]),
    'subheading' => __('Selamat datang di dashboard Anda.'),
    ])

    <div class="grid grid-cols-1 gap-6 lg:grid-cols-3">
        <!-- Total Domains -->
        <div class="rounded-2xl border bg-white p-6 shadow-sm dark:border-neutral-700 dark:bg-gray-900">
            <div class="text-sm text-gray-500 dark:text-gray-400">{{ __('Total Domains') }}</div>
            <div class="mt-2 text-4xl font-bold text-gray-900 dark:text-white">{{ $totalDomains }}</div>
        </div>

        <!-- Total Name Servers -->
        <div class="rounded-2xl border bg-white p-6 shadow-sm dark:border-neutral-700 dark:bg-gray-900">
            <div class="text-sm text-gray-500 dark:text-gray-400">{{ __('Total Name Servers') }}</div>
            <div class="mt-2 text-4xl font-bold text-gray-900 dark:text-white">{{ $totalNameServers }}</div>
        </div>
    </div>
</x-layouts.app>
